package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.control.TipoCambioImpl;
import com.ejie.ab04b.model.HistCambiosAperturas;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0487s00DaoImpl generated by UDA, 27-feb-2017 9:02:46.
 * 
 * @author UDA
 */

@Repository
@Transactional
public class HistCambiosAperturasDaoImpl implements HistCambiosAperturasDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<HistCambiosAperturas> rwMap = new RowMapper<HistCambiosAperturas>() {
		public HistCambiosAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new HistCambiosAperturas(resultSet.getLong("IDAPE087"),
					resultSet.getString("TIPOCAMBIO087"),
					resultSet.getTimestamp("FECMODIF087"),
					resultSet.getString("REGORIGINAL087"),
					resultSet.getString("REGMIDIFICACIONES087"),
					resultSet.getString("MIGRADO087"),
					TipoCambioImpl.getInstance()
							.getValue(resultSet.getString("TIPOCAMBIO087"))
							.getDescripcionEs(),
					TipoCambioImpl.getInstance()
							.getValue(resultSet.getString("TIPOCAMBIO087"))
							.getDescripcionEu());
		}
	};

	private RowMapper<HistCambiosAperturas> rwMapPK = new RowMapper<HistCambiosAperturas>() {
		public HistCambiosAperturas mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new HistCambiosAperturas(resultSet.getLong("IDAPE087"),
					resultSet.getString("TIPOCAMBIO087"),
					resultSet.getTimestamp("FECMODIF087"),
					resultSet.getString("REGORIGINAL087"),
					resultSet.getString("REGMIDIFICACIONES087"),
					resultSet.getString("MIGRADO087"),
					TipoCambioImpl.getInstance()
							.getValue(resultSet.getString("TIPOCAMBIO087"))
							.getDescripcionEs(),
					TipoCambioImpl.getInstance()
							.getValue(resultSet.getString("TIPOCAMBIO087"))
							.getDescripcionEu());
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 *  dataSource            DataSource
	 *
	 * @param dataSource the new data source
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0487s00 table.
	 * 
	 *  ab0487s00
	 *            Ab0487s00
	 *  Ab0487s00
	 *
	 * @param ab0487s00 the ab 0487 s 00
	 * @return the hist cambios aperturas
	 */
	public HistCambiosAperturas add(HistCambiosAperturas ab0487s00) {
		String query = "INSERT INTO AB0487S00 (IDAPE_087, TIPOCAMBIO_087, FECMODIF_087, REGORIGINAL_087, REGMIDIFICACIONES_087, MIGRADO_087) VALUES (?,?,?,?,?,?)";
		this.jdbcTemplate.update(query, ab0487s00.getIdape087(),
				ab0487s00.getTipocambio087(), ab0487s00.getFecmodif087(),
				ab0487s00.getRegoriginal087(),
				ab0487s00.getRegmidificaciones087(), ab0487s00.getMigrado087());
		return ab0487s00;
	}

	/**
	 * Updates a single row in the Ab0487s00 table.
	 * 
	 *  ab0487s00
	 *            Ab0487s00
	 *  Ab0487s00
	 *
	 * @param ab0487s00 the ab 0487 s 00
	 * @return the hist cambios aperturas
	 */
	public HistCambiosAperturas update(HistCambiosAperturas ab0487s00) {
		String query = "UPDATE AB0487S00 SET  WHERE IDAPE_087=? AND TIPOCAMBIO_087=? AND FECMODIF_087=? AND REGORIGINAL_087=? AND REGMIDIFICACIONES_087=? AND MIGRADO_087=?";
		this.jdbcTemplate.update(query, ab0487s00.getIdape087(),
				ab0487s00.getTipocambio087(), ab0487s00.getFecmodif087(),
				ab0487s00.getRegoriginal087(),
				ab0487s00.getRegmidificaciones087(), ab0487s00.getMigrado087());
		return ab0487s00;
	}

	/**
	 * Finds a single row in the Ab0487s00 table.
	 * 
	 *  ab0487s00
	 *            Ab0487s00
	 *  Ab0487s00
	 *
	 * @param ab0487s00 the ab 0487 s 00
	 * @return the hist cambios aperturas
	 */
	@Transactional(readOnly = true)
	public HistCambiosAperturas find(HistCambiosAperturas ab0487s00) {
		String query = "SELECT t1.IDAPE_087 IDAPE087, t1.TIPOCAMBIO_087 TIPOCAMBIO087, t1.FECMODIF_087 FECMODIF087, t1.REGORIGINAL_087 REGORIGINAL087, t1.REGMIDIFICACIONES_087 REGMIDIFICACIONES087, t1.MIGRADO_087 MIGRADO087 FROM AB0487S00 t1  WHERE t1.IDAPE_087 = ?   AND t1.TIPOCAMBIO_087 = ?   AND t1.FECMODIF_087 = ?   AND t1.REGORIGINAL_087 = ?   AND t1.REGMIDIFICACIONES_087 = ?   AND t1.MIGRADO_087 = ?  ";

		List<HistCambiosAperturas> ab0487s00List = this.jdbcTemplate.query(
				query, this.rwMap, ab0487s00.getIdape087(),
				ab0487s00.getTipocambio087(), ab0487s00.getFecmodif087(),
				ab0487s00.getRegoriginal087(),
				ab0487s00.getRegmidificaciones087(), ab0487s00.getMigrado087());
		return (HistCambiosAperturas) DataAccessUtils
				.uniqueResult(ab0487s00List);
	}

	/**
	 * Removes a single row in the Ab0487s00 table.
	 * 
	 *  ab0487s00            Ab0487s00
	 *
	 * @param ab0487s00 the ab 0487 s 00
	 */
	public void remove(HistCambiosAperturas ab0487s00) {
		String query = "DELETE FROM AB0487S00 WHERE IDAPE_087=? AND TIPOCAMBIO_087=? AND FECMODIF_087=? AND REGORIGINAL_087=? AND REGMIDIFICACIONES_087=? AND MIGRADO_087=?";
		this.jdbcTemplate.update(query, ab0487s00.getIdape087(),
				ab0487s00.getTipocambio087(), ab0487s00.getFecmodif087(),
				ab0487s00.getRegoriginal087(),
				ab0487s00.getRegmidificaciones087(), ab0487s00.getMigrado087());
	}

	/**
	 * Finds a list of rows in the Ab0487s00 table.
	 * 
	 *  ab0487s00
	 *            Ab0487s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Ab0487s00>
	 *
	 * @param ab0487s00 the ab 0487 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<HistCambiosAperturas> findAll(HistCambiosAperturas ab0487s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDAPE_087 IDAPE087,t1.TIPOCAMBIO_087 TIPOCAMBIO087,t1.FECMODIF_087 FECMODIF087,t1.REGORIGINAL_087 REGORIGINAL087,t1.REGMIDIFICACIONES_087 REGMIDIFICACIONES087,t1.MIGRADO_087 MIGRADO087 ");
		query.append("FROM AB0487S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0487s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);
		query.append(" ORDER BY FECMODIF_087 DESC ");

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<HistCambiosAperturas>) this.jdbcTemplate
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0487s00 table using like.
	 * 
	 *  ab0487s00
	 *            Ab0487s00
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  startsWith
	 *            Boolean
	 *  List<Ab0487s00>
	 *
	 * @param ab0487s00 the ab 0487 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<HistCambiosAperturas> findAllLike(
			HistCambiosAperturas ab0487s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.IDAPE_087 IDAPE087,t1.TIPOCAMBIO_087 TIPOCAMBIO087,t1.FECMODIF_087 FECMODIF087,t1.REGORIGINAL_087 REGORIGINAL087,t1.REGMIDIFICACIONES_087 REGMIDIFICACIONES087,t1.MIGRADO_087 MIGRADO087 ");
		query.append("FROM AB0487S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0487s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<HistCambiosAperturas>) this.jdbcTemplate
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0487s00 table.
	 * 
	 *  ab0487s00
	 *            Ab0487s00
	 *  Long
	 *
	 * @param ab0487s00 the ab 0487 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(HistCambiosAperturas ab0487s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0487S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0487s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0487s00 table using like.
	 * 
	 *  ab0487s00
	 *            Ab0487s00
	 *  startsWith
	 *            Boolean
	 *  Long
	 *
	 * @param ab0487s00 the ab 0487 s 00
	 * @param startsWith the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(HistCambiosAperturas ab0487s00,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0487S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0487s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0487s00 selected for rup_table.
	 * 
	 *  ab0487s00            Ab0487s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0487s00>>
	 *
	 * @param ab0487s00 the ab 0487 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<HistCambiosAperturas>> reorderSelection(
			HistCambiosAperturas ab0487s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDAPE_087 IDAPE087,t1.TIPOCAMBIO_087 TIPOCAMBIO087,t1.FECMODIF_087 FECMODIF087,t1.REGORIGINAL_087 REGORIGINAL087,t1.REGMIDIFICACIONES_087 REGMIDIFICACIONES087,t1.MIGRADO_087 MIGRADO087 ");
		// FROM
		query.append("FROM AB0487S00 t1 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0487s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, HistCambiosAperturas.class,
				filterParamList,
				"IDAPE_087,TIPOCAMBIO_087,FECMODIF_087,REGORIGINAL_087,REGMIDIFICACIONES_087,MIGRADO_087");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<HistCambiosAperturas>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 *  filterParams            Ab0487s00
	 *  searchParams            Ab0487s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *  List<TableRowDto<Ab0487s00>>
	 *
	 * @param filterParams the filter params
	 * @param searchParams the search params
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 * @return the list
	 */
	@Override
	public List<TableRowDto<HistCambiosAperturas>> search(
			HistCambiosAperturas filterParams,
			HistCambiosAperturas searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDAPE_087 IDAPE087,t1.TIPOCAMBIO_087 TIPOCAMBIO087,t1.FECMODIF_087 FECMODIF087,t1.REGORIGINAL_087 REGORIGINAL087,t1.REGMIDIFICACIONES_087 REGMIDIFICACIONES087,t1.MIGRADO_087 MIGRADO087 ");
		// FROM
		query.append("FROM AB0487S00 t1 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, HistCambiosAperturas.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"IDAPE_087,TIPOCAMBIO_087,FECMODIF_087,REGORIGINAL_087,REGMIDIFICACIONES_087,MIGRADO_087");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<HistCambiosAperturas>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Remove multiple method for rup_table.
	 * 
	 *  filterab0487s00            Ab0487s00
	 *  jqGridRequestDto            JQGridRequestDto
	 *  startsWith            Boolean
	 *
	 * @param filterab0487s00 the filterab 0487 s 00
	 * @param jqGridRequestDto the jq grid request dto
	 * @param startsWith the starts with
	 */
	@Override
	public void removeMultiple(HistCambiosAperturas filterab0487s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.IDAPE_087 IDAPE087,t1.TIPOCAMBIO_087 TIPOCAMBIO087,t1.FECMODIF_087 FECMODIF087,t1.REGORIGINAL_087 REGORIGINAL087,t1.REGMIDIFICACIONES_087 REGMIDIFICACIONES087,t1.MIGRADO_087 MIGRADO087 ");
		// FROM
		query.append("FROM AB0487S00 t1 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab0487s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto,
						HistCambiosAperturas.class, query, params,
						"IDAPE_087,TIPOCAMBIO_087,FECMODIF_087,REGORIGINAL_087,REGMIDIFICACIONES_087,MIGRADO_087");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0487s00 entity.
	 * 
	 *  ab0487s00            Ab0487s00 Bean with the criteria values to filter by.
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0487s00 the ab 0487 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(HistCambiosAperturas ab0487s00) {

		StringBuilder where = new StringBuilder(
				HistCambiosAperturasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0487s00 != null && ab0487s00.getIdape087() != null) {
			where.append(" AND t1.IDAPE_087 = ?");
			params.add(ab0487s00.getIdape087());
		}
		if (ab0487s00 != null && ab0487s00.getTipocambio087() != null) {
			where.append(" AND t1.TIPOCAMBIO_087 = ?");
			params.add(ab0487s00.getTipocambio087());
		}
		if (ab0487s00 != null && ab0487s00.getFecmodif087() != null) {
			where.append(" AND t1.FECMODIF_087 = ?");
			params.add(ab0487s00.getFecmodif087());
		}
		if (ab0487s00 != null && ab0487s00.getRegoriginal087() != null) {
			where.append(" AND t1.REGORIGINAL_087 = ?");
			params.add(ab0487s00.getRegoriginal087());
		}
		if (ab0487s00 != null && ab0487s00.getRegmidificaciones087() != null) {
			where.append(" AND t1.REGMIDIFICACIONES_087 = ?");
			params.add(ab0487s00.getRegmidificaciones087());
		}
		if (ab0487s00 != null && ab0487s00.getMigrado087() != null) {
			where.append(" AND t1.MIGRADO_087 = ?");
			params.add(ab0487s00.getMigrado087());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0487s00 entity.
	 * 
	 *  ab0487s00            Ab0487s00 Bean with the criteria values to filter by.
	 *  startsWith            Boolean
	 *  Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 *
	 * @param ab0487s00 the ab 0487 s 00
	 * @param startsWith the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(HistCambiosAperturas ab0487s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				HistCambiosAperturasDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0487s00 != null && ab0487s00.getIdape087() != null) {
			where.append(" AND t1.IDAPE_087 = ?");
			params.add(ab0487s00.getIdape087());
		}
		if (ab0487s00 != null && ab0487s00.getTipocambio087() != null) {
			where.append(" AND UPPER(t1.TIPOCAMBIO_087) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0487s00.getTipocambio087().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0487s00.getTipocambio087().toUpperCase() + "%");
			}
			where.append(" AND t1.TIPOCAMBIO_087 IS NOT NULL");
		}
		if (ab0487s00 != null && ab0487s00.getFecmodif087() != null) {
			where.append(" AND t1.FECMODIF_087 = ?");
			params.add(ab0487s00.getFecmodif087());
		}
		if (ab0487s00 != null && ab0487s00.getRegoriginal087() != null) {
			where.append(" AND UPPER(t1.REGORIGINAL_087) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0487s00.getRegoriginal087().toUpperCase() + "%");
			} else {
				params.add("%" + ab0487s00.getRegoriginal087().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.REGORIGINAL_087 IS NOT NULL");
		}
		if (ab0487s00 != null && ab0487s00.getRegmidificaciones087() != null) {
			where.append(
					" AND UPPER(t1.REGMIDIFICACIONES_087) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0487s00.getRegmidificaciones087().toUpperCase()
						+ "%");
			} else {
				params.add(
						"%" + ab0487s00.getRegmidificaciones087().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.REGMIDIFICACIONES_087 IS NOT NULL");
		}
		if (ab0487s00 != null && ab0487s00.getMigrado087() != null) {
			where.append(" AND UPPER(t1.MIGRADO_087) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0487s00.getMigrado087().toUpperCase() + "%");
			} else {
				params.add("%" + ab0487s00.getMigrado087().toUpperCase() + "%");
			}
			where.append(" AND t1.MIGRADO_087 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
